/* cooks a raw binary image for the apple */

#include <stdio.h>
#include <stdlib.h>
#include <fcntl.h>
#include <string.h>
#include <dos.h>
#include <bios.h>
#include <io.h>
#include <malloc.h>
#include <conio.h>


unsigned char far *raw;  /* image */

int ragcook(char *name)
{
    FILE *fp;
    int fh;

    long counter=0,target;
    unsigned packet;
    unsigned char c;

    char *wordptr;
    char buf1[66],buf2[66];

    if((fp=fopen(name,"rb"))==NULL)return -1;
    target=filelength(fileno(fp));
    packet = (unsigned)target;
    fclose(fp);

    raw= _fmalloc(packet);

    fh = open(name,O_RDONLY|O_BINARY);
    read(fh,raw,packet);
    close(fh);

    /* now open the text file */

    strcpy(buf1,name);
    wordptr=strtok(buf1,".");
    sprintf(buf2,"%s.NAP",buf1);

    fp=fopen(buf2,"w");
    fprintf(fp,
     "/* character array created from binary image fragment %s */\n",
    name);

    target-=2;
    fprintf(fp,"int %s_SIZE = %ld;\n",buf1,target);
    fprintf(fp,"int %s_WIDTH= %d;\n",buf1,*raw++);
    fprintf(fp,"int %s_HEIGHT=%d;\n",buf1,*raw++);


    fprintf(fp,"char %s[%ld]={\n",buf1,target);

    for(counter=0;counter<target;counter++)
        {
        if( (counter%14)==0)fprintf(fp,"\n");
        fprintf(fp,"%3d",raw[counter]);
        if(counter<(target-1))fprintf(fp,",");
        }

        fprintf(fp,"};\n");
        fclose(fp);

    _ffree(raw);
    return 0;

}



main(int argc, char *argv[])
{

    if(argc==2)ragcook(argv[1]);
    exit(0);

}


